const admin = require("../model/admin");
const jsonwebtoken = require('jsonwebtoken')




const AuthAdmin = async (req,res,next)=> {
    try {
        let token = req.headers.authorization.split(' ')[1]
        // console.log("TOKEN PROVIDED: "+token);
        let id = jsonwebtoken.decode(token,'jwt')
        let activeAdmin = await admin.findOne({_id: id.cu})
        req.user = activeAdmin
        // console.log("activeAdmin => ", activeAdmin);
        // console.log("activeAdmin => ", activeAdmin);
        if(!activeAdmin) new Error('invalid admin id found');
         next();
    } catch (error) {
        console.log(error);
        res.status(500)
        .json({
            error:true,
            msg: 'invalid user in session',
            data:null
        })
    }
}

module.exports = AuthAdmin;