const jsonwebtoken = require("jsonwebtoken")
const UserModel = require('../model/user');



const AuthUserToken = async (req,res,next) => {
    // TRY BLOCK 
    try {
        let token = req.headers.authorization.split(' ')[1]
        // console.log("TOKEN PROVIDED: "+token);
        let userDetails = jsonwebtoken.decode(token,'jwt')
        // console.log("userDetails: "+userDetails);
        // check if user is not disabled or suspended 
        let userInSession = await UserModel.findOne({_id: userDetails._id})//search for the user in the database 
        if(!userInSession) return res.status(403).json({error:true, data:null,msg: 'Account not found, please contact support for further help'})
        //sign new token
        let newToken = jsonwebtoken.sign({...userInSession._doc,password:null},'jwt')
        req.token = newToken;
        req.user = userInSession;
        next();//calls the next function 
    }
    // CATCH BLOCK FOR EXCEPTIONS 
    catch (error) {
        return res.status(500).json({error:true,msg: 'opps!!!, session expired, please login to continue.', data:null, e:error})
    }
}

module.exports = AuthUserToken;