const {Schema, model} = require('mongoose');
const moment = require('moment');
const {btc, eth, ltc} = require('./coin');

const UserModel = new Schema({
  investment_plan: String,
  image: String,
  img: Object,
  reg_date: {
    type: String,
    default: moment().format('lll'),
  },
  walletType: {
    type: String,
  },
  balance: {
    type: Number,
    default: 0,
  },
  running: {
    type: Array,
    default: []
  },
  running_deposit: {
    type: Number,
    default: 0,
  },
  running_balance: {
    type: Number,
    default: 0,
  },
  total_deposit: {
    type: Number,
    default: 0,
  },
  active_deposit: {
    type: Number,
    default: 0,
  },
  total_earning: {
    type: Number,
    default: 0,
  },
  total_withdrawal: {
    type: Number,
    default: 0,
  },
  bonus: {
    type: Number,
    default: 0,
  },
  total_penalty: {
    type: Number,
    default: 0,
  },
  pending_withdrawal: {
    type: Number,
    default: 0,
  },
  pending_deposit: {
    type: Number,
    default: 0,
  },
  referral_commission: {
    type: Number,
    default: 0,
  },
  active: {
    type: Boolean,
    default: false,
  },
  suspended: {
    type: Boolean,
    default: false,
  },
  disabled: {
    type: Boolean,
    default: false,
  },
  username: {
    type: String,
    required: true,
    unique: true,
  },
  email: {
    type: String,
    required: true,
    unique: true,
  },
  full_name: {
    type: String,
    required: true,
  },
  password: {
    type: Object,
  },
  country: String,
  address: String,
  bio: String,
  dob: String,
  phone: String,
  photo: String,
  upline: {
    type: String,
    default: 'System || no up line',
  },
  referral: {
    type: Number,
    default: 0,
  },
  bitcoin_address: String,
  ethereum_address: String,
  usdt_address: String,
  account_type: String,
  total_earned: Number,
},{
  timestamps: true
});

//export to the db
module.exports = model('user', UserModel);

// Manage user funds:
// Account balance: how many funds can the user deposit to any investment package or withdraw from the system.
// Total deposit: how many funds has the user ever deposited to your system.
// Total active deposit: the whole current deposit of this user.
// Total earnings: how many funds has the user ever earned with your system.
// Total withdrawals: how many funds has the user ever withdrawn from system.
// Total bonus: how many funds has the administrator ever added to the user account as a bonus.
// Total penalty: how many funds has the administrator ever deleted from the user account as a penalty.
// Actions:
// Transactions history - you can check the transactions history for this user.
// Active deposits/Transactions history - you can check the deposits history for this user.
// Earnings history - you can check the earnings history for this user.
// Withdrawals history - you can check the withdrawals history for this user.
// Process withdrawals - you can withdraw funds by clicking this link if a user asked you for a withdrawal.
// Bonuses history - you can check the bonuses history for this user.
// Penalties history - you can check the penalties history for this user.
// Add a bonus and add a penalty - add a bonus or a penalty to this user.
