const admin = require('../../model/admin');

const Router = require('express').Router()


// CREATE ADMIN USER
Router.post('/', async (req,res)=>{
    try {
        let {username='', password=''} = req.body;
        //check if the username is already in use 
        let usernameIsInUse = await admin.findOne({username});
        if(usernameIsInUse) return res.status(401).json({
            error:true,
            msg:'Admin username already in use',
            data:null
        })
        let newAdminInSystem = await admin.create({username,password})
        res.status(201)
        .json({
            error:false,
            data: 'Admin account created successfully, please login to continue',
            msg: null
        })
        console.log(newAdminInSystem);
    } catch (error) {
        console.log(error);
        res.status(500)
        .json({
            error:true,
            e:error,
            data:null,
            msg: 'Opps!!!, an unknown error occured on the server.'
        })
    }
})  


module.exports = Router;