const AuthAdmin = require("../../../middlewares/authAdmin");
const deposit = require("../../../model/deposit");
const user = require("../../../model/user");

const Router = require("express").Router();

// LIST THE DEPOSITS MADE BY ALL USERS
Router.get("/", AuthAdmin, async (req, res) => {
  try {
    // let {start=0,limit=10} = req.query;
    const page = parseInt(req.query.page);
    const limit = parseInt(req.query.limit);
    const skipIndex = (page - 1) * limit;
    // let allDeposit = await deposit.find({pending:true}).sort({'date': -1}).populate('uid')
    let allDeposit = await deposit
      // .find({
      //   uid: {
      //     $in: await user.find({ suspended: false })
      //   },
      // })
      .find()
      .sort({ updatedAt: -1 })
      .populate("uid");
    // .limit(parseInt(limit) || 10).skip(parseInt(skipIndex));

    res.paginatedResults = { results: allDeposit };
    res.json({
      allDeposit,
      next_page: page + 1,
      previous_page: page == 1 ? 1 : page - 1,
    });
  } catch (error) {
    console.log(error);
    res
      .status(400)
      .json({ error: true, e: error, msg: "internal server error occured" });
  }
});

// LIST DEPOSIT BY A SPECIFIC USER USING ID {}

Router.get("/:user_id", AuthAdmin, async (req, res) => {
  try {
    let _id = req.params.user_id;
    let allDepositByUser = await deposit
      .find({ uid: _id })
      .sort({ createdAt: -1 })
      .populate("uid", { email: 1, full_name: 1, username: 1 });
    res.json({ allDepositByUser, total: allDepositByUser.length });
  } catch (error) {
    console.log(error);
    res.status(401).json({
      error: true,
      data: null,
      msg: "unable to complete action, an error was encountered.",
    });
  }
});

module.exports = Router;
