const Plans = require("../../model/plan");
const Wallet = require("../../model/wallets");
const AuthAdmin = require("../../middlewares/authAdmin");
const Router = require("express").Router();

// get wallet from admin
Router.get("/", async (req, res) => {
  try {
    let Admin = await Plans.find();
    let WalletAgain = await Wallet.find();
    // console.log('Wallet => ', WalletAgain);
    // console.log('Admin => ', Admin);
    // let { wallet } = Admin[0].dataValues;
    //   res.json(ServerRequest(Admin]));
    // console.log("Admin => ", Admin);

    return res.status(200).json({
      plans: Admin.length > 0 ? Admin[0] : { plans: [] },
      data: WalletAgain.length > 0 ? WalletAgain[0] : [],
      msg: "successful",
      err: false,
    });
  } catch (error) {
    console.log(error);
    res.status(500).json(ServerError("Unable to get admin wallet"));
  }
});

// post plan from admin
Router.post("/", AuthAdmin, async (req, res) => {
  try {
    let find = await Plans.find();

    if (find.length > 0) {
      const update = await Plans.findOneAndUpdate(
        { _id: find[0]._id },
        { plans: req.body.plans },
        { new: true }
      );
      return res
        .status(201)
        .json({ date: update, msg: "successful", err: false });
    }

    let save = await new Plans({
      plans: req.body.plans,
    });

    const saved = await save.save();
    return res.status(201).json({ date: saved, msg: "successful", err: false });
  } catch (error) {
    console.log(error);
    res.status(500).json(ServerError("Unable to get admin wallet"));
  }
});


// post plan from admin
Router.post("/wallet", async (req, res) => {
  try {
    let find = await Wallet.find();

    if (find.length > 0) {
      const update = await Wallet.findOneAndUpdate(
        { _id: find[0]._id },
        {wallets: req.body.wallets },
        { new: true }
      );
      return res
        .status(201)
        .json({ date: update, msg: "successful", err: false });
    }

    let save = await new Wallet({
      wallets: req.body.wallets,
    });

    const saved = await save.save();
    return res.status(201).json({ date: saved, msg: "successful", err: false });
  } catch (error) {
    console.log(error);
    res.status(500).json(ServerError("Unable to get admin wallet"));
  }
});

module.exports = Router;
