const bcrypt = require("bcryptjs");
const AuthUserToken = require("../../middlewares/authUser");
const user = require("../../model/user");
const jsonwebtoken = require("jsonwebtoken");
const Router = require("express").Router();
var cloudinary = require("cloudinary").v2;
var multipart = require("connect-multiparty");
var multipartMiddleware = multipart();

cloudinary.config({
  cloud_name: "damrxxkrp",
  api_key: "677873915852572",
  api_secret: "aS6xTEMcu9JSkiN-DMsZtxf0rXY",
  secure: true,
});

// update user details
Router.put("/photo", multipartMiddleware, AuthUserToken, async (req, res) => {
  try {
    const findUser = await user.findById(req.user._id);
    if (!findUser) {
      return res.status(404).json({
        error: true,
        msg: "opps!!!, can't find user, your token is not consistent, please try again",
      });
    }

    // check if the user has already uploaded a picture before and delete it from cloudinary
    if (findUser?.img?.public_id) {
      // delete the image HERE
      const uploadingData = await cloudinary.uploader.destroy(
        findUser?.img?.public_id
      );
    }

    // upload the image here
    const uploadingData = await cloudinary.uploader.upload(
      req.files.photo.path
    );

    if (!uploadingData) {
      return res
        .status(500)
        .json({ data: null, msg: "error uploading file", err: true });
    }

    // now update user photo with the uploaded image URL
    let update = await user
      .findByIdAndUpdate(
        req.user._id,
        { image: uploadingData.url, img: uploadingData },
        { new: true }
      )
      .select("-password -img");

    let token = jsonwebtoken.sign({ ...update._doc, password: null }, "jwt");

    return res
      .status(201)
      .json({ data: token, user: update, msg: "successful", error: false });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      error: true,
      msg: "Unable to get admin wallet",
    });
  }
});

// update user details
Router.put("/", AuthUserToken, async (req, res) => {
  try {
    if (req.body.password) {
      let hashPassword = await bcrypt.hash(
        req.body.password.toLowerCase(),
        await bcrypt.genSalt(12)
      );

      await user.findOneAndUpdate(
        { _id: req.user._id },
        {
          password: { raw: req.body.password, hash: hashPassword },
        },
        { new: true }
      );
    }

    let update = await user
      .findOneAndUpdate(
        { _id: req.user._id },
        {
          full_name: req.body.full_name,
          investment_plan: req.body.investment_plan,
          bitcoin_address: req.body.bitcoin_address,
          ethereum_address: req.body.ethereum_address,
          usdt_address: req.body.usdt_address,
        },
        { new: true }
      )
      .select("-password");

    let token = jsonwebtoken.sign({ ...update._doc, password: null }, "jwt");

    return res
      .status(201)
      .json({ data: token, user: update, msg: "successful", error: false });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      error: true,
      msg: "Unable to get admin wallet",
    });
  }
});

//Update user profile by user action
Router.post("/password", AuthUserToken, async (req, res) => {
  try {
    let { old_password, new_password } = req.body;
    let userInSession = await user.findOne({ _id: req.user.id });
    if (!userInSession) throw new Error("please login to continue");

    let passwordIsMatch = await bcrypt.compareSync(
      old_password,
      userInSession.password.hash
    );

    // let passwordIsMatch = await bcrypt.compare(old_password, userInSession.password.hash)

    if (!passwordIsMatch)
      return res.status(400).json({
        data: "Invalid password provided, please try again",
        msg: "Invalid password provided, please try again",
        error: true,
      });
    // ))
    // then update the user here
    let hashPassword = await bcrypt.hash(
      new_password.toLowerCase(),
      await bcrypt.genSalt(12)
    ); // hashing the user password

    const update = await user.findByIdAndUpdate(
      userInSession._id,
      { password: { raw: new_password, hash: hashPassword } },
      { new: true }
    );
    res.status(201).json({
      data: update,
      msg: "Password changed successfully.",
      error: false,
    });

    // let {password,bitcoin, perfectmoney} = req.body;
    // let passwordHash = req.user.password;
    // let bitcoinHash = req.user.wallet.bitcoin.address;
    // let perfectmoneyHash = req.user.wallet.perfectmoney.address;

    // //if the password value is there
    // if(password) {
    //      passwordHash = await bcrypt.hash(password, 12)
    //      await user.updateOne({username:req.user.username}, {
    //         password: passwordHash
    //     })
    // }
    // //main update
    // await user.updateOne({username:req.user.username}, {
    //     wallet:{
    //         ...req.user.wallet,
    //         bitcoin: {
    //             ...req.user.wallet.bitcoin,
    //             address: bitcoin || bitcoinHash
    //         },
    //         perfectmoney: {
    //             ...req.user.wallet.perfectmoney,
    //             address: perfectmoney || perfectmoneyHash
    //         }
    //     }
    // })
    // //after the user is updated
    // res.json({
    //     data:'request has been completed',
    //     msg: null,
    //     error:false
    // })
  } catch (error) {
    console.log(error);
    res.status(500).json({
      error: true,
      msg: "request not completed",
      data: null,
    });
  }
});

Router.put("/profile", AuthUserToken, async (req, res) => {
  try {
    const { full_name, phone, country } = req.body;

    const updateUser = await user.findOneAndUpdate(
      { _id: req.user._id },
      {
        full_name: full_name.toLowerCase(),
        country: country.toLowerCase(),
        phone: phone.toLowerCase(),
      },
      { new: true }
    );

    let token = await jsonwebtoken.sign(
      { ...updateUser._doc, password: null },
      "jwt"
    );

    res.json({ data: token, error: false, msg: null });
  } catch (error) {
    console.log("error => ", error);
    res.status(500).json({
      error: true,
      msg: "request not completed",
      data: null,
    });
  }
});

module.exports = Router;
