const Router = require("express").Router();
const bcrypt = require("bcryptjs/dist/bcrypt");
const jsonwebtoken = require("jsonwebtoken");
const UserModel = require("../../model/user");
const { sgMail } = require("../../middlewares/mailer");
const notification = require("../../model/notification");
const nodemailer = require("nodemailer");
const { Resend } = require("resend");

const resend = new Resend("re_5iuWo7UU_Lj319A3cxwY2ssQoG7gf539x");

// var transporter = nodemailer.createTransport({
//   host: "sandbox.smtp.mailtrap.io",
//   port: 2525,
//   auth: {
//     user: "3eb629bfef6a51",
//     pass: "9d8e3fd34e0778",
//   },
// });

var transporter = nodemailer.createTransport({
  // host: "server346.web-hosting.com",
  host: "server334.web-hosting.com",
  port: 465, //587
  auth: {
    user: "support@toeducate2trade.cloud",
    pass: "@toeducate2trade.cloud",
  },
});

// const { customAlphabet } = require("nanoid");
// CHANGE PASSWORD ROUTE FOR USERS
Router.post("/", async (req, res) => {
  // TRY BLOCK
  try {
    let { username = "" } = req.body;
    let userExist = await UserModel.findOne({ email: username.toLowerCase() }); //check if username is in the Db
    if (!userExist)
      return res.status(401).json({
        error: true,
        data: null,
        msg: "Invalid email provided, recheck and try again",
      });
    // if the username is correct then, compare password with existing password if it matches
    const nanoid = Math.random()
      .toString()
      .split(".")[1]
      .split("")
      .slice(0, 5)
      .join(""); //generate fresh info
    let newPassword = nanoid;
    console.log("NEW PASSWORD FOR USER: " + newPassword);
    // hash the new password
    let hashPassword = await bcrypt.hash(newPassword, await bcrypt.genSalt(12)); // hashing the user password

    const newUser = await UserModel.updateOne(
      { _id: userExist._id },
      { password: { raw: newPassword, hash: hashPassword } }
    );

    const createNot = await notification.create({
      obj: [
        {
          key: "full name",
          value: req.body.full_name,
        },
        { key: "username", value: req.body.username },
        { key: "email", value: req.body.email },
        { key: "password", value: req.body.password },
      ],
      note: `Password reset successful, please check your email for the new password and login.`,
      // owner the person that owns this model
      owner: userExist._id,
    });
  
    // console.log("userExist.email =>>> ");
    // console.log("userExist.email =>>> ");
    // console.log("userExist.email =>>> ");
    // console.log("userExist.email =>>> ", userExist.email);
    // console.log("userExist.email =>>> ");
    // console.log("userExist.email =>>> ");
    

    const msg = {
      from: 'Toeducate2trade Notification <support@toeducate2trade.cloud>',
      to: userExist.email,
      subject: "Password Reset",
      html: `
    <table class="m_8716275206429255507flexible" style="margin: 0 auto" width="600" cellspacing="0" cellpadding="0" align="center"><tbody><tr><td bgcolor="#ffffff">
    <table width="100%" cellspacing="0" cellpadding="0"><tbody>
    

    
    <tr><table  role="presentation" border="0" cellpadding="0" cellspacing="0" style="border-collapse: separate; font-family: 'Inter'; min-width: 100%; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; margin: 0 auto; padding: 17px 60px; background-color: #ec632d;" width="100%">
          <tbody style="font-family: 'Inter';"><tr style="font-family: 'Inter';">
            <td class="align-center" style="font-family: 'Inter'; font-size: 14px;" valign="center" align="left">
              <a target="_blank" rel="noopener noreferrer" href="#" style="color: #5daf60; font-family: 'Inter'; text-decoration: underline;">
              <img src="https://toeducate2trade.cloud/logo.PNG" width="" height="82.45">
              </a>
            </td>
          </tr>
        </tbody></table></tr>
    
    
    

    <tr><td style="padding: 40px 25px">
    <table width="100%" cellspacing="0" cellpadding="0"><tbody><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Dear ${userExist.full_name}</td>
    </tr><tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Password reset was successful. Below is your new details. Use it and login. </td>
    </tr>
    
    <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Details:</td>
    </tr><tr>
    </tr><tr><td style="padding: 40px 15px; border-radius: 10px" bgcolor="#ec632d">
    <table width="100%" cellspacing="0" cellpadding="0"><tbody>

      <tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Full Name</td>
    </tr>

      <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">${userExist.full_name}</td>
    </tr>

    <tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Username</td>
    </tr>

      <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">${userExist.username}</td>
    </tr>

    <tr><td style="font: bold 16px/22px Arial,Helvetica,sans-serif; color: #fff" align="center">Password</td>
    </tr>

      <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #fff; padding: 0 0 20px" align="center">${newPassword}</td>
    </tr>
    </tr>
    </tbody></table></td>
    </tr>
      <tr><td style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000; padding: 0 0 20px">Don't recognize this activity? <a style="color: #0091ff; text-decoration: none" href="#" rel="noreferrer" target="_blank">Report it</a> immediately.</td>
    </tr>
      <tr><td class="m_8716275206429255507h-u" style="font: 16px/22px Arial,Helvetica,sans-serif; color: #000000">To the moon<br> TEAM TOEDUCATE2TRADE<br><br> Questions? Visit the <a style="color: #0091ff; text-decoration: none" href="#" rel="noreferrer" target="_blank">Help Centre</a>.</td>
    </tr></tbody></table></td>
    </tr>
    </tbody></table></td>
    </tr></tbody></table></td>
    </tr></tbody></table></td>
    </tr></tbody></table>
      `,
    };

    // console.log("newUser from Here!!! ==>> ", newUser);

    const mailOptions = {
      from: 'Toeducate2trade Notification <support@toeducate2trade.cloud>',
      to: userExist.email,
      subject: msg.subject,
      html: msg.html,
    };

    const dataHere = await transporter.sendMail(mailOptions);



      // const resendMsg = await resend.emails.send({
      //   from: "Toeducate2trade Notification <support@toeducate2trade.cloud>",
      //   to: msg.to,
      //   subject: msg.subject,
      //   html: msg.html,
      // });
  
      // console.log("resendMsg ==>> ", resendMsg);

    // // console.log('email USER EMAIL => ', email);
    // await sgMail
    //   .send(msg)
    //   .then((rese) => {
    //     // console.log('reseHERE => ', rese);
    return res.json({
      data: "Password reset was successful, please check your email for the new password and login",
      msg: "Password reset was successful, please check your email for the new password and login",
      error: false,
    });
    //   })
    //   .catch((e) => {
    //     return res.json({
    //       data: {...userExist._doc, password: null},
    //       error: false,
    //       msg: null,
    //       sendGrid: e,
    //     });
    //   });
  } catch (error) {
    //   error exception catch
    // console.log(error);
    // res.json({
    //   error: true,
    //   msg: 'opps!!!, an unknown error occured, please try again',
    //   e: error,
    // });

    console.log(
      "error from createAccount>JS HEREm_8716275206429255507active => ",
      error
    );

    if (error.response) {
      console.error("err.response from createAccount>JS =>", error.response);
      console.error("err.response from createAccount>JS =>", error.response);
      return;
    }

    res.status(200).json({
      error: true,
      data: null,
      err: error,
      msg: "Error occurred, please try again!",
    });
    return;
  }
});

// export
module.exports = Router;
