const Router = require('express').Router()
const bcrypt = require('bcryptjs/dist/bcrypt');
const jsonwebtoken = require('jsonwebtoken');
const UserModel = require('../../model/user')

// LOGIN ROUTE FOR USERS 
Router.post('/', async (req,res)=> {
    // TRY BLOCK 
    try {

        
        let {username = '',password = ''} = req.body;
        let userExist = await UserModel.findOne({username: username.toLowerCase()}) //check if username is in the Db 
        let emailExist = await UserModel.findOne({email: username.toLowerCase()}) //check if username is in the Db 
        
        if(!userExist && !emailExist) return res.status(401).json({error:true, data:null,msg: 'Invalid username and password combination, please check and try again'})
        
        
        let info = !userExist ? emailExist._doc : userExist._doc;
        
        // console.log("info => ", info);
        
        // if(info?.suspended) return res.status(401).json({error:true, data:null,msg: 'Your account has been suspended, please  contact support'})
        
        // if the username is correct then, compare password with existing password if it matches
        let passwordIsMatch = await bcrypt.compare(password, info.password.hash)

            // if(!passwordIsMatch) {
            //     passwordIsMatch = await bcrypt.compare(password,emailExist.password)
            // }
        console.log("PASSWORD MATCH TEST: "+passwordIsMatch);
        //if the details are correct, then proceed with the auth of the user
        if(!passwordIsMatch) return res.status(401).json({error:true, data:null,msg: 'Invalid username and password combination, please check and try again'})


        let token = jsonwebtoken.sign({...info, password: null},'jwt');
        res.json({data:token,error:false,msg: null}) //login successful 
    } 
    // ERROR BLOCK FOR ASYNC ACTIONS 
    catch (error) {
        console.log("error, => ", error);
        return res.status(500).json({error: true, msg: 'opps!!!, an unknown error occurred, please try again', data:null})
    }
    // END 
})



// export 
module.exports = Router;