const AuthUserToken = require("../../middlewares/authUser");
const user = require("../../model/user");

const Router = require("express").Router();

Router.get("/", AuthUserToken, async (req, res) => {
  try {
    let allUserRef = await user.find({ upline: req.user.username }).select("balance reg_date full_name investment_plan");
    let allUserRefActive = await user.find({
      upline: req.user.username,
      active: true,
    });
    res.json({
      error: false,
      msg: null,
      data: {
        refs: allUserRef,
        activeRefs: allUserRefActive,
      },
    });
  } catch (error) {
    console.log(error);
    res.status(500).json({
      error: true,
      msg: "unable to complete request, please try again",
      data: null,
    });
  }
});

module.exports = Router;
